/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.service.scrape;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.scent.persist.mongo.v1.ScrapeTask;
import ai.platon.scent.persist.mongo.v1.ScrapeTask48HourHistory;
import ai.platon.scent.persist.mongo.v1.ScrapeTaskHistory;
import ai.platon.scent.persist.mongo.v1.ScrapeTaskMonthlyHistory;
import ai.platon.scent.rest.api.service.scrape.RedisTaskQueueService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0012J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\rH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lai/platon/scent/rest/api/service/scrape/TaskPersistenceService;", "Lorg/springframework/data/redis/connection/MessageListener;", "mongoTemplate", "Lorg/springframework/data/mongodb/core/MongoTemplate;", "redisTemplate", "Lorg/springframework/data/redis/core/RedisTemplate;", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lorg/springframework/data/mongodb/core/MongoTemplate;Lorg/springframework/data/redis/core/RedisTemplate;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "logger", "Lorg/slf4j/Logger;", "getTaskFromRedis", "Lai/platon/scent/persist/mongo/v1/ScrapeTask;", "taskId", "onMessage", "", "message", "Lorg/springframework/data/redis/connection/Message;", "pattern", "", "persistTask", "task", "scent-rest"})
public class TaskPersistenceService
implements MessageListener {
    @NotNull
    private final MongoTemplate mongoTemplate;
    @NotNull
    private final RedisTemplate<String, String> redisTemplate;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final Logger logger;

    public TaskPersistenceService(@NotNull MongoTemplate mongoTemplate, @NotNull RedisTemplate<String, String> redisTemplate, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)mongoTemplate, (String)"mongoTemplate");
        Intrinsics.checkNotNullParameter(redisTemplate, (String)"redisTemplate");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.mongoTemplate = mongoTemplate;
        this.redisTemplate = redisTemplate;
        this.objectMapper = objectMapper;
        this.logger = LogsKt.getLogger((Object)this);
        this.redisTemplate.execute(arg_0 -> TaskPersistenceService._init_$lambda$0(this, arg_0));
    }

    public void onMessage(@NotNull Message message, @Nullable byte[] pattern) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        try {
            RedisTaskQueueService.TaskStatusMessage statusMessage = (RedisTaskQueueService.TaskStatusMessage)this.objectMapper.readValue(message.getBody(), RedisTaskQueueService.TaskStatusMessage.class);
            ScrapeTask scrapeTask = this.getTaskFromRedis(statusMessage.getTaskId());
            if (scrapeTask == null) {
                return;
            }
            ScrapeTask task = scrapeTask;
            if (ChronoUnit.HOURS.between(task.getCreatedAt(), Instant.now()) <= 48L) {
                ScrapeTask48HourHistory history = new ScrapeTask48HourHistory(task);
                this.mongoTemplate.save((Object)history);
            } else if (ChronoUnit.DAYS.between(task.getCreatedAt(), Instant.now()) <= 30L) {
                ScrapeTaskMonthlyHistory history = new ScrapeTaskMonthlyHistory(task);
                this.mongoTemplate.save((Object)history);
            } else {
                ScrapeTaskHistory history = new ScrapeTaskHistory(task);
                this.mongoTemplate.save((Object)history);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to process task status message", (Throwable)e);
        }
    }

    private ScrapeTask getTaskFromRedis(String taskId) {
        ScrapeTask scrapeTask;
        try {
            String taskKey = "scrape:task:" + taskId;
            String taskJson = (String)this.redisTemplate.opsForValue().get((Object)taskKey);
            scrapeTask = taskJson != null ? (ScrapeTask)this.objectMapper.readValue(taskJson, ScrapeTask.class) : null;
        }
        catch (Exception e) {
            this.logger.error("Failed to get task from Redis", (Throwable)e);
            scrapeTask = null;
        }
        return scrapeTask;
    }

    public void persistTask(@NotNull ScrapeTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        try {
            if (ChronoUnit.HOURS.between(task.getCreatedAt(), Instant.now()) <= 48L) {
                ScrapeTask48HourHistory history = new ScrapeTask48HourHistory(task);
                this.mongoTemplate.save((Object)history);
            } else if (ChronoUnit.DAYS.between(task.getCreatedAt(), Instant.now()) <= 30L) {
                ScrapeTaskMonthlyHistory history = new ScrapeTaskMonthlyHistory(task);
                this.mongoTemplate.save((Object)history);
            } else {
                ScrapeTaskHistory history = new ScrapeTaskHistory(task);
                this.mongoTemplate.save((Object)history);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to persist task", (Throwable)e);
        }
    }

    private static final Unit _init_$lambda$0(TaskPersistenceService this$0, RedisConnection connection) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        MessageListener messageListener = this$0;
        byte[][] byArrayArray = new byte[1][];
        String string = "scrape:task:status";
        Intrinsics.checkNotNullExpressionValue((Object)string.getBytes(Charsets.UTF_8), (String)"getBytes(...)");
        connection.subscribe(messageListener, (byte[][])byArrayArray);
        return Unit.INSTANCE;
    }
}

