/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.ml;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.math.vectors.VectorsKt;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.features.FeatureRegistry;
import ai.platon.pulsar.dom.features.NodeFeature;
import ai.platon.pulsar.dom.nodes.NodesKt;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.pulsar.skeleton.common.options.LoadOptions;
import ai.platon.scent.BasicScentSession;
import ai.platon.scent.dom.HarvestOptions;
import ai.platon.scent.dom.features.defined.DefinedFeaturesKt;
import ai.platon.scent.ql.h2.context.ScentSQLContexts;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.KType;
import kotlin.reflect.full.KTypes;
import kotlin.test.AssertionsKt;
import kotlin.text.StringsKt;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.AppendKt;
import org.jetbrains.kotlinx.dataframe.api.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.api.CountKt;
import org.jetbrains.kotlinx.dataframe.api.DataFrameBuilder;
import org.jetbrains.kotlinx.dataframe.api.MeanKt;
import org.jetbrains.kotlinx.dataframe.api.PrintKt;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.io.CsvKt;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0012\u001a\n\u0012\u0002\b\u00030\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0007J\b\u0010\u001c\u001a\u00020\u0018H\u0007J\b\u0010\u001d\u001a\u00020\u0018H\u0007J\b\u0010\u001e\u001a\u00020\u0018H\u0007J\b\u0010\u001f\u001a\u00020\u0018H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lai/platon/scent/ml/EncoderTests;", "", "()V", "FEATURE_FORMATTER", "Ljava/text/DecimalFormat;", "args", "", "csvFormat", "Lorg/apache/commons/csv/CSVFormat;", "kotlin.jvm.PlatformType", "primaryFeatureKeys", "", "", "primaryFeatureNames", "productUrls", "session", "Lai/platon/scent/BasicScentSession;", "url", "encode", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "document", "Lai/platon/pulsar/dom/FeaturedDocument;", "encodeDirect", "", "pr", "Lorg/apache/commons/csv/CSVPrinter;", "testEncodeDocuments", "testEncodeDocumentsAndExportWithCSVPrinter", "testEncodeSingleDocument", "testRegisteredFeatures", "testSerializeRecordToCSV", "scent-tests"})
@SourceDebugExtension(value={"SMAP\nEncoderTests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncoderTests.kt\nai/platon/scent/ml/EncoderTests\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 constructors.kt\norg/jetbrains/kotlinx/dataframe/api/DataFrameBuilder\n*L\n1#1,181:1\n1#2:182\n1855#3,2:183\n1864#3,3:185\n1855#3,2:188\n1864#3,3:190\n344#4,7:193\n344#4,7:200\n*S KotlinDebug\n*F\n+ 1 EncoderTests.kt\nai/platon/scent/ml/EncoderTests\n*L\n76#1:183,2\n112#1:185,3\n134#1:188,2\n139#1:190,3\n148#1:193,7\n149#1:200,7\n*E\n"})
public final class EncoderTests {
    @NotNull
    private final BasicScentSession session = ScentSQLContexts.INSTANCE.createSession();
    @NotNull
    private final String url;
    @NotNull
    private final String args;
    @NotNull
    private final List<String> productUrls;
    private final CSVFormat csvFormat;
    @NotNull
    private final DecimalFormat FEATURE_FORMATTER;
    @NotNull
    private final List<String> primaryFeatureNames;
    @NotNull
    private final List<Integer> primaryFeatureKeys;

    public EncoderTests() {
        this.url = "https://www.amazon.com/dp/B0C1H26C46";
        this.args = "-requireSize 1000000";
        Object[] objectArray = new String[]{"https://www.amazon.com/dp/B009FUF6DM", "https://www.amazon.com/dp/B083XFNH46", "https://www.amazon.com/dp/B005NAG9BQ", "https://www.amazon.com/dp/B00K5ZL266", "https://www.amazon.com/dp/B07QFBVZK2", "https://www.amazon.com/dp/B07R4T9WCD", "https://www.amazon.com/dp/B0025TZ26Q", "https://www.amazon.com/dp/B07Y7FXDGW"};
        this.productUrls = CollectionsKt.listOf((Object[])objectArray);
        this.csvFormat = CSVFormat.EXCEL;
        this.FEATURE_FORMATTER = new DecimalFormat("#.####");
        this.primaryFeatureNames = FeatureRegistry.INSTANCE.getPrimaryFeatureNames();
        this.primaryFeatureKeys = FeatureRegistry.INSTANCE.getPrimaryFeatureKeys();
    }

    @Test
    public final void testSerializeRecordToCSV() {
        FeaturedDocument document = this.session.loadDocument(this.url);
        Element node = document.getBody();
        RealVector realVector = node.getExtension().getFeatures();
        Intrinsics.checkNotNull((Object)realVector, (String)"null cannot be cast to non-null type org.apache.commons.math3.linear.ArrayRealVector");
        ArrayRealVector vector = (ArrayRealVector)realVector;
        String text = "a,b,\"c*%#d-.e";
        Object object = node.ownerDocument();
        if (object == null || (object = NodeExtKt.getNormalizedURI((Document)object)) == null) {
            return;
        }
        Object url = object;
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        double[] dArray = vector.getDataRef();
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"getDataRef(...)");
        spreadBuilder.addSpread((Object)ArraysKt.toTypedArray((double[])dArray));
        spreadBuilder.add((Object)text);
        spreadBuilder.add(url);
        Object[] record = spreadBuilder.toArray(new Object[spreadBuilder.size()]);
        System.out.println(ArraysKt.toList((Object[])record));
        AssertionsKt.assertEquals$default((Object)(DefinedFeaturesKt.getN2() + 2), (Object)record.length, null, (int)4, null);
        String line = this.csvFormat.format(Arrays.copyOf(record, record.length));
        System.out.println((Object)line);
        String string = null;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)line);
        AssertionsKt.assertTrue((boolean)StringsKt.contains$default((CharSequence)line, (CharSequence)"c*%#d-.e", (boolean)false, (int)2, null), string);
        CSVParser cSVParser = CSVParser.parse((String)line, (CSVFormat)this.csvFormat);
        Intrinsics.checkNotNullExpressionValue((Object)cSVParser, (String)"parse(...)");
        CSVRecord record2 = (CSVRecord)CollectionsKt.first((Iterable)((Iterable)cSVParser));
        String string2 = null;
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)record2);
        AssertionsKt.assertTrue((boolean)CollectionsKt.contains((Iterable)((Iterable)record2), (Object)String.valueOf(VectorsKt.get((RealVector)((RealVector)vector), (int)0))), string2);
        string2 = null;
        boolean bl3 = false;
        AssertionsKt.assertTrue((boolean)CollectionsKt.contains((Iterable)((Iterable)record2), (Object)String.valueOf(VectorsKt.get((RealVector)((RealVector)vector), (int)1))), string2);
        string2 = null;
        boolean bl4 = false;
        AssertionsKt.assertTrue((boolean)CollectionsKt.contains((Iterable)((Iterable)record2), (Object)text), string2);
        string2 = null;
        boolean bl5 = false;
        AssertionsKt.assertTrue((boolean)CollectionsKt.contains((Iterable)((Iterable)record2), (Object)url), string2);
        System.out.println(record2.toList());
    }

    @Test
    public final void testRegisteredFeatures() {
        Iterable $this$forEach$iv = FeatureRegistry.INSTANCE.getRegisteredFeatures();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NodeFeature it = (NodeFeature)element$iv;
            boolean bl = false;
            System.out.println(it);
        }
        AssertionsKt.assertEquals$default((Object)DefinedFeaturesKt.getN2(), (Object)FeatureRegistry.INSTANCE.getRegisteredFeatures().size(), null, (int)4, null);
    }

    @Test
    public final void testEncodeSingleDocument() {
        FeaturedDocument document = this.session.loadDocument(this.url);
        RealVector realVector = document.getBody().getExtension().getFeatures();
        Intrinsics.checkNotNull((Object)realVector, (String)"null cannot be cast to non-null type org.apache.commons.math3.linear.ArrayRealVector");
        ArrayRealVector features = (ArrayRealVector)realVector;
        AssertionsKt.assertEquals$default((Object)DefinedFeaturesKt.getN2(), (Object)features.getDimension(), null, (int)4, null);
        DataFrame<?> df = this.encode(document);
        PrintKt.print$default(df, (int)0, (int)0, (boolean)true, (boolean)false, (boolean)true, (boolean)true, (int)11, null);
        String[] stringArray = new String[]{"top", "left", "width", "height"};
        DataRow mean1 = MeanKt.meanFor$default(df, (String[])stringArray, (boolean)false, (int)2, null);
        PrintKt.print((DataRow)mean1);
        String fileId = AppPaths.INSTANCE.fileId(this.url);
        String[] stringArray2 = new String[]{"dataframe-" + fileId + ".csv"};
        Path path = AppPaths.INSTANCE.getTmp("test", stringArray2);
        Assumptions.assumeTrue((boolean)Files.exists(path, new LinkOption[0]), (String)("Test file does not) exist: " + path));
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        CsvKt.writeCSV$default(df, (File)file, null, (int)2, null);
        System.out.println((Object)("Dataframe is exported | " + path));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public final void testEncodeDocuments() {
        HarvestOptions options = this.session.options(this.args);
        int ndoc = this.productUrls.size();
        Path path = AppPaths.INSTANCE.getTEST_DIR().resolve("dataframe-" + ndoc + ".csv");
        Files.deleteIfExists(path);
        int nrow = 0;
        Iterable $this$forEachIndexed$iv = this.productUrls;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void url;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int i = n;
            boolean bl = false;
            FeaturedDocument document = this.session.loadDocument((String)url, (LoadOptions)options);
            DataFrame<?> df = this.encode(document);
            nrow += CountKt.count(df);
            CSVFormat csvFormat = CSVFormat.DEFAULT.withSkipHeaderRecord(i > 0);
            Appendable appendable = new FileWriter(path.toFile(), true);
            Intrinsics.checkNotNull((Object)csvFormat);
            CsvKt.writeCSV(df, (Appendable)appendable, (CSVFormat)csvFormat);
        }
        System.out.println((Object)("Total " + nrow + " rows in " + ndoc + " documents"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public final void testEncodeDocumentsAndExportWithCSVPrinter() {
        HarvestOptions options = this.session.options(this.args);
        int ndoc = this.productUrls.size();
        Path path = AppPaths.INSTANCE.getTEST_DIR().resolve("dataframe-" + ndoc + "-csv-printer.csv");
        Files.deleteIfExists(path);
        BufferedWriter writer = new BufferedWriter(new FileWriter(path.toFile(), true));
        CSVPrinter printer = new CSVPrinter((Appendable)writer, this.csvFormat);
        Iterable $this$forEach$iv = FeatureRegistry.INSTANCE.getPrimaryFeatureNames();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            printer.print((Object)it);
        }
        printer.print((Object)"text");
        printer.print((Object)"url");
        printer.println();
        Iterable $this$forEachIndexed$iv = this.productUrls;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void url;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int i = n;
            boolean bl = false;
            FeaturedDocument document = this.session.loadDocument((String)url, (LoadOptions)options);
            this.encodeDirect(document, printer);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final DataFrame<?> encode(FeaturedDocument document) {
        void nrow$iv;
        void this_$iv;
        void nrow$iv22;
        void this_$iv2;
        Ref.IntRef limit = new Ref.IntRef();
        limit.element = 200000;
        Ref.ObjectRef numericFeatures = new Ref.ObjectRef();
        DataFrameBuilder dataFrameBuilder = ConstructorsKt.dataFrameOf((Iterable)FeatureRegistry.INSTANCE.getFeatureNames());
        boolean bl = false;
        Double value$iv22 = 0.0;
        boolean $i$f$fill = false;
        numericFeatures.element = this_$iv2.withColumns(new Function1<String, DataColumn<?>>((int)nrow$iv22, value$iv22){
            final /* synthetic */ int $nrow;
            final /* synthetic */ Object $value;
            {
                this.$nrow = $nrow;
                this.$value = $value;
                super(1);
            }

            @NotNull
            public final DataColumn<?> invoke(@NotNull String name) {
                ArrayList<Object> arrayList;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                Object object = this.$value;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Object> arrayList2 = new ArrayList<Object>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    arrayList = arrayList2;
                    boolean bl = false;
                    arrayList.add(object);
                }
                arrayList = arrayList2;
                return (DataColumn)DataColumn.Companion.createValueColumn$default((DataColumn.Companion)companion, (String)string, arrayList, (KType)KTypes.withNullability((KType)Reflection.typeOf(Double.TYPE), (this.$value == null ? 1 : 0) != 0), null, null, (int)24, null);
            }
        });
        Ref.ObjectRef textFeatures = new Ref.ObjectRef();
        String[] nrow$iv22 = new String[]{"text", "url"};
        nrow$iv22 = ConstructorsKt.dataFrameOf((String[])nrow$iv22);
        boolean value$iv22 = false;
        String value$iv = "";
        boolean $i$f$fill2 = false;
        textFeatures.element = this_$iv.withColumns(new Function1<String, DataColumn<?>>((int)nrow$iv, value$iv){
            final /* synthetic */ int $nrow;
            final /* synthetic */ Object $value;
            {
                this.$nrow = $nrow;
                this.$value = $value;
                super(1);
            }

            @NotNull
            public final DataColumn<?> invoke(@NotNull String name) {
                ArrayList<Object> arrayList;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                Object object = this.$value;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Object> arrayList2 = new ArrayList<Object>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    arrayList = arrayList2;
                    boolean bl = false;
                    arrayList.add(object);
                }
                arrayList = arrayList2;
                return (DataColumn)DataColumn.Companion.createValueColumn$default((DataColumn.Companion)companion, (String)string, arrayList, (KType)KTypes.withNullability((KType)Reflection.typeOf(String.class), (this.$value == null ? 1 : 0) != 0), null, null, (int)24, null);
            }
        });
        NodesKt.forEach$default((Node)((Node)document.getBody()), (boolean)false, (Function1)((Function1)new Function1<Node, Unit>(limit, numericFeatures, document, textFeatures){
            final /* synthetic */ Ref.IntRef $limit;
            final /* synthetic */ Ref.ObjectRef<DataFrame<?>> $numericFeatures;
            final /* synthetic */ FeaturedDocument $document;
            final /* synthetic */ Ref.ObjectRef<DataFrame<?>> $textFeatures;
            {
                this.$limit = $limit;
                this.$numericFeatures = $numericFeatures;
                this.$document = $document;
                this.$textFeatures = $textFeatures;
                super(1);
            }

            public final void invoke(@NotNull Node node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node instanceof TextNode && NodeExtKt.getLeft((Node)node) > 0 && NodeExtKt.getTop((Node)node) > 0 && !StringsKt.isBlank((CharSequence)NodeExtKt.getCleanText((Node)node))) {
                    int n = this.$limit.element;
                    this.$limit.element = n + -1;
                    if (n > 0) {
                        RealVector realVector = ((TextNode)node).getExtension().getFeatures();
                        Intrinsics.checkNotNull((Object)realVector, (String)"null cannot be cast to non-null type org.apache.commons.math3.linear.ArrayRealVector");
                        ArrayRealVector featureVector = (ArrayRealVector)realVector;
                        double[] dArray = featureVector.getDataRef();
                        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"getDataRef(...)");
                        Double[] f = ArraysKt.toTypedArray((double[])dArray);
                        AssertionsKt.assertEquals$default((Object)DefinedFeaturesKt.getN2(), (Object)f.length, null, (int)4, null);
                        this.$numericFeatures.element = AppendKt.append((DataFrame)((DataFrame)this.$numericFeatures.element), (Object[])Arrays.copyOf(f, f.length));
                        String text = NodeExtKt.getCleanText((Node)node);
                        String url0 = this.$document.getNormalizedURI();
                        Object[] objectArray = new Object[]{text, url0};
                        this.$textFeatures.element = AppendKt.append((DataFrame)((DataFrame)this.$textFeatures.element), (Object[])objectArray);
                    }
                }
            }
        }), (int)1, null);
        return TypeConversionsKt.asColumnGroup((DataFrame)((DataFrame)numericFeatures.element), (String)"numericFeatures").plus((BaseColumn)((DataFrame)textFeatures.element).get("text")).plus((BaseColumn)((DataFrame)textFeatures.element).get("url"));
    }

    private final void encodeDirect(FeaturedDocument document, CSVPrinter pr) {
        NodesKt.forEach$default((Node)((Node)document.getBody()), (boolean)false, (Function1)((Function1)new Function1<Node, Unit>(this, pr, document){
            final /* synthetic */ EncoderTests this$0;
            final /* synthetic */ CSVPrinter $pr;
            final /* synthetic */ FeaturedDocument $document;
            {
                this.this$0 = $receiver;
                this.$pr = $pr;
                this.$document = $document;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Node node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node instanceof TextNode && NodeExtKt.getLeft((Node)node) > 0 && NodeExtKt.getTop((Node)node) > 0 && !StringsKt.isBlank((CharSequence)NodeExtKt.getCleanText((Node)node))) {
                    void $this$forEach$iv;
                    RealVector realVector = ((TextNode)node).getExtension().getFeatures();
                    Intrinsics.checkNotNull((Object)realVector, (String)"null cannot be cast to non-null type org.apache.commons.math3.linear.ArrayRealVector");
                    ArrayRealVector vector = (ArrayRealVector)realVector;
                    Iterable iterable = EncoderTests.access$getPrimaryFeatureKeys$p(this.this$0);
                    CSVPrinter cSVPrinter = this.$pr;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        int it = ((Number)element$iv).intValue();
                        boolean bl = false;
                        cSVPrinter.print((Object)vector.getDataRef()[it]);
                    }
                    this.$pr.print((Object)NodeExtKt.getCleanText((Node)node));
                    this.$pr.print((Object)this.$document.getNormalizedURI());
                    this.$pr.println();
                }
            }
        }), (int)1, null);
    }

    public static final /* synthetic */ List access$getPrimaryFeatureKeys$p(EncoderTests $this) {
        return $this.primaryFeatureKeys;
    }
}

