/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.test.client;

import ai.platon.pulsar.common.LangKt;
import ai.platon.scent.common.ScentURLUtils;
import ai.platon.scent.crawl.serialize.CompactedScrapeResponse;
import ai.platon.scent.crawl.serialize.ScrapeRequestV1;
import ai.platon.scent.crawl.serialize.ScrapeResponse;
import ai.platon.scent.entities.UserDashboard;
import ai.platon.scent.support.JacksonPageImpl;
import ai.platon.scent.test.client.TestScentClient;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJl\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00052\u0014\b\u0002\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020'0&2\u0014\b\u0002\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020'0&2\u0014\b\u0002\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020'0&2\b\b\u0002\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020+J\u0018\u0010-\u001a\u00020.2\u0006\u0010$\u001a\u00020\u00052\b\b\u0002\u0010/\u001a\u000200J(\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010$\u001a\u00020\u00052\b\b\u0002\u00104\u001a\u00020\u00072\b\b\u0002\u00105\u001a\u00020\u0007J \u00106\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00052\b\b\u0002\u00107\u001a\u00020\u0007J,\u00108\u001a\b\u0012\u0004\u0012\u00020\"092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00050;2\u0006\u0010$\u001a\u00020\u00052\b\b\u0002\u00107\u001a\u00020\u0007J\u000e\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020>R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\fR\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\fR\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\fR\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\fR\u0011\u0010\u001f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\f\u00a8\u0006?"}, d2={"Lai/platon/scent/test/client/TestScentClient;", "", "restTemplate", "Lorg/springframework/boot/test/web/client/TestRestTemplate;", "server", "", "port", "", "contextPath", "(Lorg/springframework/boot/test/web/client/TestRestTemplate;Ljava/lang/String;ILjava/lang/String;)V", "baseUri", "getBaseUri", "()Ljava/lang/String;", "getContextPath", "dashboardApi", "getDashboardApi", "downloadApi", "getDownloadApi", "getPort", "()I", "getRestTemplate", "()Lorg/springframework/boot/test/web/client/TestRestTemplate;", "scrapeApi", "getScrapeApi", "scrapeBaseUri", "getScrapeBaseUri", "scrapeStatusApi", "getScrapeStatusApi", "scrapeStatusesApi", "getScrapeStatusesApi", "getServer", "userBaseUri", "getUserBaseUri", "await", "Lai/platon/scent/crawl/serialize/ScrapeResponse;", "id", "authToken", "onResponded", "Lkotlin/Function1;", "", "onComplete", "onTimeout", "checkInterval", "", "timeout", "dashboard", "Lai/platon/scent/entities/UserDashboard;", "refresh", "", "download", "Lorg/springframework/data/domain/Page;", "Lai/platon/scent/crawl/serialize/CompactedScrapeResponse;", "pageNumber", "pageSize", "getScrapeStatus", "debugLevel", "getScrapeStatuses", "", "ids", "", "scrape", "request", "Lai/platon/scent/crawl/serialize/ScrapeRequestV1;", "scent-tests"})
public class TestScentClient {
    @NotNull
    private final TestRestTemplate restTemplate;
    @NotNull
    private final String server;
    private final int port;
    @NotNull
    private final String contextPath;
    @NotNull
    private final String scrapeBaseUri;
    @NotNull
    private final String scrapeApi;
    @NotNull
    private final String scrapeStatusApi;
    @NotNull
    private final String scrapeStatusesApi;
    @NotNull
    private final String userBaseUri;
    @NotNull
    private final String dashboardApi;
    @NotNull
    private final String downloadApi;

    public TestScentClient(@NotNull TestRestTemplate restTemplate, @NotNull String server, int port, @NotNull String contextPath) {
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)contextPath, (String)"contextPath");
        this.restTemplate = restTemplate;
        this.server = server;
        this.port = port;
        this.contextPath = contextPath;
        this.scrapeBaseUri = this.getBaseUri() + "/x/a";
        this.scrapeApi = this.scrapeBaseUri + "/q";
        this.scrapeStatusApi = this.scrapeBaseUri + "/status?id={id}&authToken={authToken}";
        this.scrapeStatusesApi = this.scrapeBaseUri + "/statuses?ids={ids}&authToken={authToken}";
        this.userBaseUri = this.getBaseUri() + "/users/{authToken}";
        this.dashboardApi = this.userBaseUri + "/dashboard";
        this.downloadApi = this.userBaseUri + "/download";
    }

    public /* synthetic */ TestScentClient(TestRestTemplate testRestTemplate, String string, int n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = "localhost";
        }
        if ((n2 & 4) != 0) {
            n = 8182;
        }
        if ((n2 & 8) != 0) {
            string2 = "/";
        }
        this(testRestTemplate, string, n, string2);
    }

    @NotNull
    public final TestRestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    @NotNull
    public final String getServer() {
        return this.server;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getContextPath() {
        return this.contextPath;
    }

    @NotNull
    public final String getBaseUri() {
        return ScentURLUtils.INSTANCE.buildServerUrl(this.server, this.port, this.contextPath, "api");
    }

    @NotNull
    public final String getScrapeBaseUri() {
        return this.scrapeBaseUri;
    }

    @NotNull
    public final String getScrapeApi() {
        return this.scrapeApi;
    }

    @NotNull
    public final String getScrapeStatusApi() {
        return this.scrapeStatusApi;
    }

    @NotNull
    public final String getScrapeStatusesApi() {
        return this.scrapeStatusesApi;
    }

    @NotNull
    public final String getUserBaseUri() {
        return this.userBaseUri;
    }

    @NotNull
    public final String getDashboardApi() {
        return this.dashboardApi;
    }

    @NotNull
    public final String getDownloadApi() {
        return this.downloadApi;
    }

    @NotNull
    public final UserDashboard dashboard(@NotNull String authToken, boolean refresh) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        String url = this.dashboardApi + "?refresh={refresh}";
        Object[] objectArray = new Object[]{authToken, refresh};
        Object object = this.restTemplate.getForObject(url, UserDashboard.class, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getForObject(...)");
        return (UserDashboard)object;
    }

    public static /* synthetic */ UserDashboard dashboard$default(TestScentClient testScentClient, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dashboard");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return testScentClient.dashboard(string, bl);
    }

    @NotNull
    public final String scrape(@NotNull ScrapeRequestV1 request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object = this.restTemplate.postForObject(this.scrapeApi, (Object)request, String.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"postForObject(...)");
        return (String)object;
    }

    @NotNull
    public final ScrapeResponse getScrapeStatus(@NotNull String id, @NotNull String authToken, int debugLevel) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Object[] objectArray = new Object[]{id, authToken};
        Object object = this.restTemplate.getForObject(this.scrapeStatusApi, ScrapeResponse.class, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getForObject(...)");
        return (ScrapeResponse)object;
    }

    public static /* synthetic */ ScrapeResponse getScrapeStatus$default(TestScentClient testScentClient, String string, String string2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getScrapeStatus");
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return testScentClient.getScrapeStatus(string, string2, n);
    }

    @NotNull
    public final List<ScrapeResponse> getScrapeStatuses(@NotNull Iterable<String> ids, @NotNull String authToken, int debugLevel) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        ParameterizedTypeReference<ArrayList<ScrapeResponse>> responseType2 = new ParameterizedTypeReference<ArrayList<ScrapeResponse>>(){};
        Object object = new Object[]{CollectionsKt.joinToString$default(ids, (CharSequence)"|", null, null, (int)0, null, (Function1)getScrapeStatuses.responseEntity.1.INSTANCE, (int)30, null), authToken};
        ResponseEntity responseEntity2 = this.restTemplate.exchange(this.scrapeStatusesApi, HttpMethod.GET, null, (ParameterizedTypeReference)responseType2, object);
        object = (ArrayList)responseEntity2.getBody();
        return object == null ? CollectionsKt.emptyList() : (List)object;
    }

    public static /* synthetic */ List getScrapeStatuses$default(TestScentClient testScentClient, Iterable iterable, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getScrapeStatuses");
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return testScentClient.getScrapeStatuses(iterable, string, n);
    }

    @NotNull
    public final Page<CompactedScrapeResponse> download(@NotNull String authToken, int pageNumber, int pageSize) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        String uri = this.downloadApi + "?pageNumber={pageNumber}&pageSize={pageSize}";
        ParameterizedTypeReference<JacksonPageImpl<CompactedScrapeResponse>> responseType2 = new ParameterizedTypeReference<JacksonPageImpl<CompactedScrapeResponse>>(){};
        Object[] objectArray = new Object[]{authToken, pageNumber, pageSize};
        ResponseEntity responseEntity2 = this.restTemplate.exchange(uri, HttpMethod.GET, null, (ParameterizedTypeReference)responseType2, objectArray);
        JacksonPageImpl jacksonPageImpl = (JacksonPageImpl)responseEntity2.getBody();
        return jacksonPageImpl == null ? (Page)new PageImpl(CollectionsKt.emptyList()) : (Page)jacksonPageImpl;
    }

    public static /* synthetic */ Page download$default(TestScentClient testScentClient, String string, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: download");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 500;
        }
        return testScentClient.download(string, n, n2);
    }

    @NotNull
    public final ScrapeResponse await(@NotNull String id, @NotNull String authToken, @NotNull Function1<? super ScrapeResponse, Unit> onResponded, @NotNull Function1<? super ScrapeResponse, Unit> onComplete, @NotNull Function1<? super ScrapeResponse, Unit> onTimeout, long checkInterval, long timeout) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter(onResponded, (String)"onResponded");
        Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
        Intrinsics.checkNotNullParameter(onTimeout, (String)"onTimeout");
        ScrapeResponse response = null;
        int tick = 0;
        do {
            if (!(response = TestScentClient.getScrapeStatus$default(this, id, authToken, 0, 4, null)).isDone()) {
                LangKt.sleepSeconds((long)checkInterval);
            }
            onResponded.invoke((Object)response);
        } while (!response.isDone() && (long)(++tick) < timeout);
        if ((long)tick >= timeout) {
            onTimeout.invoke((Object)response);
        } else {
            onComplete.invoke((Object)response);
        }
        return response;
    }

    public static /* synthetic */ ScrapeResponse await$default(TestScentClient testScentClient, String string, String string2, Function1 function1, Function1 function12, Function1 function13, long l, long l2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: await");
        }
        if ((n & 4) != 0) {
            function1 = await.1.INSTANCE;
        }
        if ((n & 8) != 0) {
            function12 = await.2.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function13 = await.3.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            l = 5L;
        }
        if ((n & 0x40) != 0) {
            l2 = 120L;
        }
        return testScentClient.await(string, string2, (Function1<? super ScrapeResponse, Unit>)function1, (Function1<? super ScrapeResponse, Unit>)function12, (Function1<? super ScrapeResponse, Unit>)function13, l, l2);
    }
}

