/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.test.client;

import ai.platon.scent.crawl.serialize.CompactedScrapeResponse;
import ai.platon.scent.crawl.serialize.ScrapeRequestV1;
import ai.platon.scent.crawl.serialize.ScrapeResponse;
import ai.platon.scent.entities.UserDashboard;
import ai.platon.scent.support.JacksonPageImpl;
import ai.platon.scent.test.client.TestAmazonClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u001b\u001a\u00020\u00052\b\b\u0002\u0010!\u001a\u00020\u0007J\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J,\u0010%\u001a\b\u0012\u0004\u0012\u00020#0&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050(2\u0006\u0010\u001b\u001a\u00020\u00052\b\b\u0002\u0010)\u001a\u00020\u0007J\u000e\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020,R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\fR\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lai/platon/scent/test/client/TestAmazonClient;", "", "restTemplate", "Lorg/springframework/boot/test/web/client/TestRestTemplate;", "server", "", "port", "", "contextPath", "(Lorg/springframework/boot/test/web/client/TestRestTemplate;Ljava/lang/String;ILjava/lang/String;)V", "baseUri", "getBaseUri", "()Ljava/lang/String;", "getContextPath", "dashboardApi", "downloadApi", "getPort", "()I", "getRestTemplate", "()Lorg/springframework/boot/test/web/client/TestRestTemplate;", "scrapeApi", "scrapeBaseUri", "scrapeStatusApi", "getServer", "userBaseUri", "dashboard", "Lai/platon/scent/entities/UserDashboard;", "authToken", "refresh", "", "download", "Lorg/springframework/data/domain/Page;", "Lai/platon/scent/crawl/serialize/CompactedScrapeResponse;", "pageNumber", "getScrapeStatus", "Lai/platon/scent/crawl/serialize/ScrapeResponse;", "id", "getScrapeStatuses", "", "ids", "", "debug", "scrape", "request", "Lai/platon/scent/crawl/serialize/ScrapeRequestV1;", "scent-tests"})
public final class TestAmazonClient {
    @NotNull
    private final TestRestTemplate restTemplate;
    @NotNull
    private final String server;
    private final int port;
    @NotNull
    private final String contextPath;
    @NotNull
    private final String scrapeBaseUri;
    @NotNull
    private final String scrapeApi;
    @NotNull
    private final String scrapeStatusApi;
    @NotNull
    private final String userBaseUri;
    @NotNull
    private final String dashboardApi;
    @NotNull
    private final String downloadApi;

    public TestAmazonClient(@NotNull TestRestTemplate restTemplate, @NotNull String server, int port, @NotNull String contextPath) {
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)contextPath, (String)"contextPath");
        this.restTemplate = restTemplate;
        this.server = server;
        this.port = port;
        this.contextPath = contextPath;
        this.scrapeBaseUri = this.getBaseUri() + "/x/a";
        this.scrapeApi = this.scrapeBaseUri + "/q";
        this.scrapeStatusApi = this.scrapeBaseUri + "/status?uuid={uuid}&authToken={authToken}";
        this.userBaseUri = this.getBaseUri() + "/users/{authToken}";
        this.dashboardApi = this.userBaseUri + "/dashboard";
        this.downloadApi = this.userBaseUri + "/download";
    }

    public /* synthetic */ TestAmazonClient(TestRestTemplate testRestTemplate, String string, int n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = "localhost";
        }
        if ((n2 & 4) != 0) {
            n = 8182;
        }
        if ((n2 & 8) != 0) {
            string2 = "/api";
        }
        this(testRestTemplate, string, n, string2);
    }

    @NotNull
    public final TestRestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    @NotNull
    public final String getServer() {
        return this.server;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getContextPath() {
        return this.contextPath;
    }

    @NotNull
    public final String getBaseUri() {
        String string = "http://%s:%d%s";
        Object[] objectArray = new Object[]{this.server, this.port, this.contextPath};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public final UserDashboard dashboard(@NotNull String authToken, boolean refresh) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        String url = this.dashboardApi + "?refresh={refresh}";
        Object[] objectArray = new Object[]{authToken, refresh};
        Object object = this.restTemplate.getForObject(url, UserDashboard.class, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getForObject(...)");
        return (UserDashboard)object;
    }

    public static /* synthetic */ UserDashboard dashboard$default(TestAmazonClient testAmazonClient, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return testAmazonClient.dashboard(string, bl);
    }

    @NotNull
    public final String scrape(@NotNull ScrapeRequestV1 request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object = this.restTemplate.postForObject(this.scrapeApi, (Object)request, String.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"postForObject(...)");
        return (String)object;
    }

    @NotNull
    public final ScrapeResponse getScrapeStatus(@NotNull String id, @NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Object[] objectArray = new Object[]{id, authToken};
        Object object = this.restTemplate.getForObject(this.scrapeStatusApi, ScrapeResponse.class, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getForObject(...)");
        return (ScrapeResponse)object;
    }

    @NotNull
    public final List<ScrapeResponse> getScrapeStatuses(@NotNull Iterable<String> ids, @NotNull String authToken, int debug) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        String uri = this.getBaseUri() + "/x/a/statuses?ids={ids}&authToken={authToken}&debug={debug}";
        ParameterizedTypeReference<ArrayList<ScrapeResponse>> responseType2 = new ParameterizedTypeReference<ArrayList<ScrapeResponse>>(){};
        Object object = new Object[]{CollectionsKt.joinToString$default(ids, (CharSequence)"|", null, null, (int)0, null, (Function1)getScrapeStatuses.responseEntity.1.INSTANCE, (int)30, null), authToken, debug};
        ResponseEntity responseEntity2 = this.restTemplate.exchange(uri, HttpMethod.GET, null, (ParameterizedTypeReference)responseType2, object);
        object = (ArrayList)responseEntity2.getBody();
        return object == null ? CollectionsKt.emptyList() : (List)object;
    }

    public static /* synthetic */ List getScrapeStatuses$default(TestAmazonClient testAmazonClient, Iterable iterable, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return testAmazonClient.getScrapeStatuses(iterable, string, n);
    }

    @NotNull
    public final Page<CompactedScrapeResponse> download(@NotNull String authToken, int pageNumber) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        String uri = this.downloadApi + "?pageNumber=" + pageNumber;
        ParameterizedTypeReference<JacksonPageImpl<CompactedScrapeResponse>> responseType2 = new ParameterizedTypeReference<JacksonPageImpl<CompactedScrapeResponse>>(){};
        Object[] objectArray = new Object[]{authToken};
        ResponseEntity responseEntity2 = this.restTemplate.exchange(uri, HttpMethod.GET, null, (ParameterizedTypeReference)responseType2, objectArray);
        JacksonPageImpl jacksonPageImpl = (JacksonPageImpl)responseEntity2.getBody();
        return jacksonPageImpl == null ? (Page)new PageImpl(CollectionsKt.emptyList()) : (Page)jacksonPageImpl;
    }

    public static /* synthetic */ Page download$default(TestAmazonClient testAmazonClient, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return testAmazonClient.download(string, n);
    }
}

